<?php
$blockedEntries = file('ball.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$visitorIp = $_SERVER['REMOTE_ADDR'];
$visitorUA = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
$blocked = false;
foreach ($blockedEntries as $entry) {
    $entry = trim($entry);
    if (strpos($visitorIp, $entry) !== false || strpos($visitorUA, $entry) !== false) {
        $blocked = true;
        break;
    }
}
if ($blocked) {
    header('HTTP/1.1 403 Forbidden');
    echo "Access Denied.";
    exit;
}
$htmlContent = file_get_contents('content.html');
if ($htmlContent === false) {
    $htmlContent = "<p>Error: Unable to load content.</p>";
}
$randomComment = "<!-- " . bin2hex(random_bytes(1000)) . " -->";
$htmlContent = $randomComment . $htmlContent;
$encodedContent = base64_encode($htmlContent);
echo trim($encodedContent);
?>
